 ; Ŀ
 ;   Dread - kill the _markup_ layer.                                      
 ;   Copyright 2002, 2004, 2005, 2010 by Rocket Software Ltd.              
 ;   Nameless dread - the fear of generic junk from value barn stores.     
 ; 

 ; Ŀ
 ;   Mf - utility - unlock the _markup_ layer, turn it magenta, resize     
 ;   all text since it appears to come in too small, fix weird             
 ;   lineweights and entity linetype scales.                               
 ; 
 (DEFUN C:MF (/ mfht ss num lll lln enam entt sub)
  (setvar "cmdecho" 0)
  (command "undo" "be")
 ; Ŀ
 ;   Unlock it, colour it magenta.                                         
 ;   The latest .rml files support entities not coloured bylayer.          
 ; 
  (command "-layer" "unlock" "_markup_" "color" "6" "_markup_" "")
 ; Ŀ
 ;   Load Misps.lsp, which contains the ps/ms scaling subroutines.         
 ; 
  (if (or (null wasp) (null misps))
      (if (null (load "misps" ()))
          (prompt "\n** The File Misps.lsp Is Not Available. **\n")))
  (setq mfht (* (misps) 2.5))
 ; Ŀ
 ;   Resize the text.                                                      
 ; 
  (if (setq ss (ssget "X" '((8 . "_markup_") (-4 . "<or") (0 . "text")
                            (0 . "mtext") (0 . "attdef") (-4 . "or>"))))
      (progn
           (setq num 0)
           (while (setq lll (ssname ss num))
                  (setq num (1+ num))
                  (setq lln (entget lll))
                  (entmod (subst (cons 40 mfht) (assoc 40 lln) lln)))))
 ; Ŀ
 ;   Reset the entity linetype scales to 1 (match the overall setting.)    
 ; 
  (if (setq ss (ssget "X" '((8 . "_markup_"))))
      (progn
           (setq num 0)
           (while (setq enam (ssname ss num))
                  (setq num (1+ num))
                  (setq entt (entget enam))
                  (if (setq sub (assoc 48 entt))
                      (entmod (subst (cons 48 1) sub entt))))))
 ; Ŀ
 ;   Reset the entity lineweights scales to bylayer (the default).         
 ; 
  (if (setq ss (ssget "X" '((8 . "_markup_"))))
      (command ".change" ss "" "p" "lw" "bylayer" ""))
 ; Ŀ
 ;   Explode all mtext.                                                    
 ; 
  (mex)
 ; Ŀ
 ;   Recolour all entities bylayer.                                        
 ; 
  (if (setq ss (ssget "X" '((8 . "_markup_"))))
      (command "change" ss "" "p" "colour" "bylayer" ""))
 ; Ŀ
 ;   End.                                                                  
 ; 
  (command "undo" "end")
 (princ))
 ; Ŀ
 ;   C:Mf end.                                                             
 ; 

 ; Ŀ
 ;   Subroutine Mex - explode all mtext.                                   
 ;   Takes no arguments, calls xylene and vortex.                          
 ;   Returns the number of mtext entities exploded, does the dishes.       
 ; 
 (DEFUN MEX (/ rad ss num enam)
  (setq rad (/ (getvar "viewsize") 35))
  (if (setq ss (ssget "X" (list (cons 0 "mtext"))))
      (progn
           (setq num 0)
           (while (setq enam (ssname ss num))
                  (setq entt (entget enam))
                  (setq pa (cdr (assoc 10 entt)))
                  (vortex pa rad num)
                  (xylene enam)
                  (setq num (1+ num)))))
 (if num num 0))
 ; Ŀ
 ;   Mex end.                                                              
 ; 

 ; Ŀ
 ;   Vortex - mark a point passed as the only argument.                    
 ; 
 (DEFUN VORTEX (pa rad colo / reps pa rad2 angg incr)
  (if (= colo 0) (setq colo 4))
  (setq reps 75)
  (setq rad2 (* rad 2))
  (setq angg 0)
  (setq incr (/ pi (/ reps 2)))
  (repeat reps
          (setq ang2 (+ angg (/ pi 5)))
          (grdraw (polar pa angg rad2) (polar pa ang2 rad) colo)
          (setq angg (+ angg incr)))
 (princ))
 ; Ŀ
 ;   Vortex end.                                                           
 ; 

 ; Ŀ
 ;   Xylene - explode an entity, put resulting subentities on the layer    
 ;   which the original entity occupied.                                   
 ;   Takes one argument, an entity name.  Returns nothing.                 
 ; 
 (DEFUN XYLENE (enam / aaa eloi ss)
 ; Ŀ
 ;   Find the last entity in the drawing.                                  
 ; 
  (setq aaa (entlast))
  (while (entnext aaa)
         (setq aaa (entnext aaa)))
 ; Ŀ
 ;   Decide which layer the entity was on, explode it.                     
 ; 
  (setq eloi (cdr (assoc 8 (entget enam))))
  (command ".explode" enam)
 ; Ŀ
 ;   Find the debris left by the explosion.                                
 ; 
  (setq ss (ssadd))
  (while (setq aaa (entnext aaa))
         (ssadd aaa ss))
 ; Ŀ
 ;   Move the new ss to the original layer.                                
 ; 
  (if (< 0 (sslength ss)) (command ".change" ss "" "p" "la" eloi ""))
 (princ))
 ; Ŀ
 ;   Xylene end.                                                           
 ; 

 ; Ŀ
 ;   Dread.                                                                
 ; 
 (DEFUN C:DREAD (/ ss)
  (if (setq ss (ssget "X" (list (cons 8 "_markup_"))))
      (command ".erase" ss ""))
  (command "-purge" "layer" "_markup_" "n")
 (princ))
